"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoggingInterceptor = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const operators_1 = require("rxjs/operators");
const log_entity_1 = require("../../entity/log.entity");
const typeorm_2 = require("typeorm");
let LoggingInterceptor = class LoggingInterceptor {
    constructor(repository) {
        this.repository = repository;
    }
    intercept(context, next) {
        const request = context.switchToHttp().getRequest();
        const method = request.method;
        const url = request.url;
        const clientIp = request.headers['x-forwarded-for'] ||
            request.socket.remoteAddress;
        console.log(clientIp);
        const startTime = Date.now();
        return next.handle().pipe((0, operators_1.tap)(() => {
            const duration = Date.now() - startTime;
            this.saveLogger(this.repository.create({
                action: method,
                address: clientIp,
                aplication: 'mobile',
                body: request?.body ? JSON.stringify(request.body) : null,
                createdAt: new Date(),
                path: url,
                user: {
                    id: null
                },
                duration
            }));
            console.log(`[Response] ${method} ${url} - ${duration}ms`);
        }));
    }
    async saveLogger(logging) {
        await this.repository.save(logging);
    }
};
exports.LoggingInterceptor = LoggingInterceptor;
exports.LoggingInterceptor = LoggingInterceptor = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(log_entity_1.LoggingEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], LoggingInterceptor);
//# sourceMappingURL=logging.interceptor.js.map