"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PublicationController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const publication_service_1 = require("./publication.service");
const query_paginate_1 = require("../../util/paginate/query-paginate");
const auth_guard_1 = require("../../middleware/auth.guard");
let PublicationController = class PublicationController {
    constructor(publicationService) {
        this.publicationService = publicationService;
    }
    async getByBusiness(query) {
        let rows = await this.publicationService.getByBusiness(query);
        return {
            statusCode: 200,
            message: ["OK"],
            ...rows
        };
    }
    async getByBusinessMap(query) {
        let rows = await this.publicationService.getByBusinessMap(query);
        return {
            statusCode: 200,
            message: ["OK"],
            ...rows
        };
    }
    async getEvents(query) {
        let rows = await this.publicationService.getEvents(query);
        return {
            statusCode: 200,
            message: ["OK"],
            ...rows
        };
    }
    async getComments(query) {
        let rows = await this.publicationService.getComments(query);
        return {
            statusCode: 200,
            message: ["OK"],
            ...rows
        };
    }
};
exports.PublicationController = PublicationController;
__decorate([
    (0, common_1.Get)('business'),
    (0, auth_guard_1.Public)(),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [query_paginate_1.PaginatePublicationBusiness]),
    __metadata("design:returntype", Promise)
], PublicationController.prototype, "getByBusiness", null);
__decorate([
    (0, common_1.Get)('map'),
    (0, auth_guard_1.Public)(),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [query_paginate_1.PaginatePublicationBusiness]),
    __metadata("design:returntype", Promise)
], PublicationController.prototype, "getByBusinessMap", null);
__decorate([
    (0, common_1.Get)('event'),
    (0, auth_guard_1.Public)(),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [query_paginate_1.PaginatePublicationBusiness]),
    __metadata("design:returntype", Promise)
], PublicationController.prototype, "getEvents", null);
__decorate([
    (0, common_1.Get)('review'),
    (0, auth_guard_1.Public)(),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [query_paginate_1.PaginatePublicationBusiness]),
    __metadata("design:returntype", Promise)
], PublicationController.prototype, "getComments", null);
exports.PublicationController = PublicationController = __decorate([
    (0, common_1.Controller)('publication'),
    (0, swagger_1.ApiTags)('publication'),
    __metadata("design:paramtypes", [publication_service_1.PublicationService])
], PublicationController);
//# sourceMappingURL=publication.controller.js.map