import { MicroService } from './micro.service';
import { PaginateSwaggerBusiness } from 'src/util/paginate/query-paginate';
import { GeoCode } from './dto/geocode.dto';
interface RequestKey {
    headers: {
        "x-api-key": string;
    };
}
export declare class MicroController {
    private microService;
    private apikey;
    constructor(microService: MicroService);
    routes(file: Buffer, data: any): Promise<{
        line: any;
        route: string;
    }>;
    all(data: PaginateSwaggerBusiness): Promise<{
        data: import("../../entity/micro.entity").MicroEntity[];
        total: number;
        page: number;
        totalPages: number;
        statusCode: number;
        message: string[];
    }>;
    plan(params: GeoCode, { headers }: RequestKey): Promise<{
        data: {
            date: number;
            from: {
                name: string;
                lon: number;
                lat: number;
                vertexType: string;
            };
            to: {
                name: string;
                lon: number;
                lat: number;
                vertexType: string;
            };
            itineraries: import("./dto/plan.response").Intinerarie[];
        };
    }>;
    getByID(id: number, { headers }: RequestKey): Promise<{
        coordinates: number[][];
        line: string;
        name: string;
        business: {
            id: number;
            name: string;
            address: string;
            latitud: number;
            longitud: number;
            logo: string;
        }[];
    }>;
}
export {};
