"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BusinessService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const business_entity_1 = require("../../entity/business.entity");
const typeorm_2 = require("typeorm");
const business_type_relation_entity_1 = require("../../entity/business-type-relation.entity");
const business_type_entity_1 = require("../../entity/business-type.entity");
const state_service_1 = require("../state/state.service");
const csv_service_1 = require("../../util/csv.service");
const state_entity_1 = require("../../entity/state.entity");
let BusinessService = class BusinessService {
    constructor(dataSource, businessEntity, relationEntity, businessTypeEntity, stateService, excelService) {
        this.dataSource = dataSource;
        this.businessEntity = businessEntity;
        this.relationEntity = relationEntity;
        this.businessTypeEntity = businessTypeEntity;
        this.stateService = stateService;
        this.excelService = excelService;
    }
    async getById(user, id) {
        this.incrementViews(id);
        const queryBuilder2 = this.businessEntity.createQueryBuilder('negocio')
            .leftJoinAndSelect('negocio.types', 'ntn')
            .leftJoinAndSelect('ntn.businessType', 'tipoNegocio')
            .leftJoinAndMapOne('negocio.state', state_entity_1.StateEntity, 'st', 'st.id=negocio.state_id')
            .where("negocio.id =:id", { id });
        return await queryBuilder2.getOne();
    }
    async incrementViews(id) {
        await this.businessEntity
            .createQueryBuilder()
            .update(business_entity_1.BusinessEntity)
            .set({ views: () => 'vistas + 1' })
            .where('id = :id', { id })
            .execute();
    }
    async getAll(query, user) {
        const like = query.search ? `%${query.search}%` : "";
        const limit = query.limit || 10;
        const page = ((query.page || 1) - 1) * limit;
        const vertical = query.vertical || 'mejor';
        const queryBuilder2 = this.businessEntity.createQueryBuilder('negocio')
            .leftJoinAndSelect('negocio.types', 'ntn')
            .leftJoinAndSelect('ntn.businessType', 'tipoNegocio')
            .leftJoinAndMapOne('negocio.departament', state_entity_1.StateEntity, 'st', 'st.id=negocio.state_id')
            .select([
            "negocio.id",
            "negocio.name",
            "negocio.logo",
            "negocio.views",
            "negocio.mejor",
            "negocio.recomendado",
            "negocio.address",
            "negocio.portada",
            "negocio.description",
            "ntn.id",
            "ntn.businessType",
            "st.id",
            "st.name",
            "tipoNegocio"
        ]);
        if (query.type) {
            const types = this.createWhere(query.type);
            queryBuilder2.andWhere('tipoNegocio.id IN (:...types)', { types });
        }
        if (query.state) {
            queryBuilder2.andWhere('negocio.state_id =:id', { id: query.state });
        }
        if (query.search) {
            queryBuilder2.andWhere("upper(business.nombre) like :search or upper(business.descripcion) like :search ", { search: like.toUpperCase() });
        }
        switch (vertical) {
            case 'mejor':
                queryBuilder2.orderBy('negocio.mejor', "DESC");
                break;
            case 'vistas':
                queryBuilder2.orderBy('negocio.views', "DESC");
                break;
            case 'recomendado':
                queryBuilder2.orderBy('negocio.recomendado', "DESC");
                break;
            default:
                queryBuilder2.orderBy("negocio.id", "DESC");
                break;
        }
        const [result, count] = await queryBuilder2
            .limit(limit)
            .offset(page)
            .getManyAndCount();
        return {
            data: result,
            total: count,
            page: query.page,
            totalPages: Math.ceil(count / limit)
        };
    }
    async getAllMap(query, user) {
        common_1.Logger.log(`**************************** **************`);
        console.log(query);
        const queryBuilder2 = this.businessEntity.createQueryBuilder('negocio')
            .leftJoinAndSelect('negocio.types', 'types')
            .leftJoinAndSelect('types.businessType', 'businessType')
            .select([
            "negocio.id",
            "negocio.name",
            "negocio.logo",
            "negocio.address",
            "negocio.latitud",
            "negocio.longitud",
            "types",
            "businessType",
        ])
            .where("negocio.state_id =:state", { state: query.state })
            .orderBy("negocio.views", "DESC");
        if (query.type) {
            const types = this.createWhere(query.type);
            if (types.length > 0)
                queryBuilder2.andWhere('businessType.id IN (:...types)', { types });
        }
        if (query.state) {
        }
        if (query.search) {
        }
        const [result, count] = await queryBuilder2
            .getManyAndCount();
        return {
            data: result,
            total: count,
        };
    }
    createWhere(type) {
        const restaurant = [2, 5, 6, 1, 11];
        const cafeteria = [1];
        const bar = [3];
        const hotel = [4];
        const entretenimiento = [7];
        const atractivo = [1];
        const pizzeria = [11];
        const churrasqueria = [6];
        const comercio = [12];
        const heladeria = [10];
        switch (type) {
            case "restaurant":
                return restaurant;
            case "hotel":
                return hotel;
            case "bar":
                return bar;
            case "cafeteria":
                return cafeteria;
            case "entretenimiento":
                return entretenimiento;
            case "atractivo":
                return atractivo;
            case "heladeria":
                return heladeria;
            case "pizzeria":
                return pizzeria;
            case "churrasqueria":
                return churrasqueria;
            case "comercio":
                return comercio;
            default:
                return [0];
        }
    }
    async create(data, user) {
        const typeBusiness = await this.businessTypeEntity.find({
            where: {
                id: (0, typeorm_2.In)(data.types)
            }
        });
        const state = await this.stateService.getById(data.idState);
        if (!state)
            throw new common_1.NotFoundException("No se encontro el estado");
        if (typeBusiness.length == 0)
            throw new common_1.NotFoundException("Error con el tipo de negocio");
        const types = typeBusiness.map(x => x.id);
        const insertBusiness = await this.businessEntity.save({
            address: data.address,
            createdAt: new Date(),
            description: data.description,
            latitud: data.latitud,
            longitud: data.longitud,
            logo: data.logo,
            state: state,
            updatedAt: new Date(),
            name: data.name,
            web: data.web,
            portada: data.portada,
            phone: data.phone
        });
        if (!insertBusiness)
            throw new common_1.NotFoundException("Error al crear negocio");
        const relations = [];
        types.forEach(element => {
            relations.push({ businessType: { id: element }, business: { id: insertBusiness.id } });
        });
        await this.relationEntity.save(relations);
        return insertBusiness;
    }
    async loadExcel(data, user) {
        const rows = await this.excelService.readExcel(data.buffer);
        for (const element of rows) {
            const data = {
                address: element["DIRECCION"],
                description: element["DETALLE"],
                idState: element["DEPARTAMENTO"],
                latitud: element["LATITUD"],
                logo: element["LOGO"],
                longitud: element["LONGITUD"],
                name: element["NOMBRE"],
                phone: element["TELEFONO"],
                portada: element["PORTADA"],
                types: element["TIPO_NEGOCIO"].split("."),
                web: element["WEB"]
            };
            const business = await this.create(data, null);
            common_1.Logger.log(`**************************** NEGOCIO CREADO **************`);
            console.log(business.name);
        }
        return rows;
    }
};
exports.BusinessService = BusinessService;
exports.BusinessService = BusinessService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectRepository)(business_entity_1.BusinessEntity)),
    __param(2, (0, typeorm_1.InjectRepository)(business_type_relation_entity_1.BusinessTypeRelationEntity)),
    __param(3, (0, typeorm_1.InjectRepository)(business_type_entity_1.BusinessTypeEntity)),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        state_service_1.StateService,
        csv_service_1.CsvService])
], BusinessService);
//# sourceMappingURL=business.service.js.map