import { BusinessEntity } from 'src/entity/business.entity';
import { UserEntity } from 'src/entity/user.entity';
import { PaginateSwaggerBusiness } from 'src/util/paginate/query-paginate';
import { DataSource, Repository } from 'typeorm';
import { CreateBusinessDTO } from './dto/create-business.dto';
import { BusinessTypeRelationEntity } from 'src/entity/business-type-relation.entity';
import { BusinessTypeEntity } from 'src/entity/business-type.entity';
import { StateService } from '../state/state.service';
import { CsvService } from 'src/util/csv.service';
import { StateEntity } from 'src/entity/state.entity';
export declare class BusinessService {
    private dataSource;
    private businessEntity;
    private relationEntity;
    private businessTypeEntity;
    private stateService;
    private readonly excelService;
    constructor(dataSource: DataSource, businessEntity: Repository<BusinessEntity>, relationEntity: Repository<BusinessTypeRelationEntity>, businessTypeEntity: Repository<BusinessTypeEntity>, stateService: StateService, excelService: CsvService);
    getById(user: UserEntity, id: number): Promise<BusinessEntity>;
    incrementViews(id: number): Promise<void>;
    getAll(query: PaginateSwaggerBusiness, user?: UserEntity): Promise<{
        data: BusinessEntity[];
        total: number;
        page: number;
        totalPages: number;
    }>;
    getAllMap(query: PaginateSwaggerBusiness, user: UserEntity): Promise<{
        data: BusinessEntity[];
        total: number;
    }>;
    createWhere(type: string): number[];
    create(data: CreateBusinessDTO, user: UserEntity): Promise<{
        address: string;
        createdAt: Date;
        description: string;
        latitud: number;
        longitud: number;
        logo: string;
        state: StateEntity;
        updatedAt: Date;
        name: string;
        web: string;
        portada: string;
        phone: string;
    } & BusinessEntity>;
    loadExcel(data: any, user: UserEntity): Promise<any[]>;
}
