import { BusinessService } from './business.service';
import { CreateBusinessDTO } from './dto/create-business.dto';
import { RequestAuth } from 'src/util/validator/format-request.dto';
import { PaginateSwaggerBusiness } from 'src/util/paginate/query-paginate';
export declare class BusinessController {
    private businessService;
    constructor(businessService: BusinessService);
    create(data: CreateBusinessDTO, { user }: RequestAuth): Promise<{
        statusCode: number;
        message: string[];
        data: {
            address: string;
            createdAt: Date;
            description: string;
            latitud: number;
            longitud: number;
            logo: string;
            state: import("../../entity/state.entity").StateEntity;
            updatedAt: Date;
            name: string;
            web: string;
            portada: string;
            phone: string;
        } & import("../../entity/business.entity").BusinessEntity;
    }>;
    createExcel(file: Buffer, { user }: RequestAuth): Promise<{
        statusCode: number;
        message: string[];
        data: any[];
    }>;
    all(data: PaginateSwaggerBusiness, { user }: RequestAuth): Promise<{
        data: import("../../entity/business.entity").BusinessEntity[];
        total: number;
        page: number;
        totalPages: number;
        statusCode: number;
        message: string[];
    }>;
    allMap(data: PaginateSwaggerBusiness, { user }: RequestAuth): Promise<{
        data: import("../../entity/business.entity").BusinessEntity[];
        total: number;
        statusCode: number;
        message: string[];
    }>;
    getById({ user }: RequestAuth, id: number): Promise<{
        statusCode: number;
        message: string[];
        data: import("../../entity/business.entity").BusinessEntity;
    }>;
}
