"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthService = void 0;
const common_1 = require("@nestjs/common");
const jwt_1 = require("@nestjs/jwt");
const typeorm_1 = require("@nestjs/typeorm");
const user_entity_1 = require("../../entity/user.entity");
const auth_token_1 = require("../../util/auth/auth-token");
const typeorm_2 = require("typeorm");
let AuthService = class AuthService {
    constructor(userEntity, jwtService, authToken) {
        this.userEntity = userEntity;
        this.jwtService = jwtService;
        this.authToken = authToken;
    }
    async signIn(data) {
        const user = await this.userEntity.createQueryBuilder('u')
            .where("(u.email=:email)", { email: data.email })
            .getOne();
        if (!user)
            throw new common_1.NotFoundException("Username and/or password incorrect.");
        let isPasswordValid = await this.authToken.comparePassword(data.password, user.password);
        if (!isPasswordValid)
            throw new common_1.NotFoundException("Username and/or password incorrect.");
        delete user.password;
        let jwt = this.jwtService.sign({ id: user.id, email: user.email, name: user.name, userType: user.userType });
        return { user, jwt };
    }
    async refreshToken(user) {
        let jwt = this.jwtService.sign({ id: user.id, email: user.email, name: user.name });
        return { user, jwt };
    }
    async signUp(data) {
        const existUser = await this.userEntity.findOne({ where: { email: data.email } });
        if (existUser)
            throw new common_1.NotFoundException("The email is already registered.");
        if (data.password !== data.verifyPassword)
            throw new common_1.NotFoundException("The passwords do not match.");
        let password = await this.authToken.hashPassword(data.password);
        data.password = password;
        let user = this.userEntity.create(data);
        user.status = 1;
        user.userType = 'usuario';
        user.profile = "";
        user = await this.userEntity.save(user);
        if (!user)
            throw new common_1.NotFoundException("Error creating user.");
        delete user.password;
        let jwt = this.jwtService.sign({ id: user.id, email: user.email, name: user.name, userType: user.userType });
        return { user, jwt };
    }
};
exports.AuthService = AuthService;
exports.AuthService = AuthService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(user_entity_1.UserEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        jwt_1.JwtService,
        auth_token_1.Bcrypt])
], AuthService);
//# sourceMappingURL=auth.service.js.map