import { JwtService } from '@nestjs/jwt';
import { UserEntity } from 'src/entity/user.entity';
import { Bcrypt } from 'src/util/auth/auth-token';
import { Repository } from 'typeorm';
import { AuthSigInDTO } from './dto/auth.dto';
import { SignUpDTO } from './dto/sign-up.dto';
export declare class AuthService {
    private userEntity;
    private jwtService;
    private authToken;
    constructor(userEntity: Repository<UserEntity>, jwtService: JwtService, authToken: Bcrypt);
    signIn(data: AuthSigInDTO): Promise<{
        user: UserEntity;
        jwt: string;
    }>;
    refreshToken(user: UserEntity): Promise<{
        user: UserEntity;
        jwt: string;
    }>;
    signUp(data: SignUpDTO): Promise<{
        user: UserEntity;
        jwt: string;
    }>;
}
