"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthController = void 0;
const common_1 = require("@nestjs/common");
const jwt_1 = require("@nestjs/jwt");
const swagger_1 = require("@nestjs/swagger");
const auth_guard_1 = require("../../middleware/auth.guard");
const auth_service_1 = require("./auth.service");
const auth_dto_1 = require("./dto/auth.dto");
const sign_up_dto_1 = require("./dto/sign-up.dto");
let AuthController = class AuthController {
    constructor(authService, jwtService) {
        this.authService = authService;
        this.jwtService = jwtService;
    }
    async signUp(data) {
        try {
            let { user, jwt } = await this.authService.signUp(data);
            return {
                statusCode: 200,
                message: ["Welcome " + user.name],
                data: user,
                jwt
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: 403,
                message: error.message
            }, common_1.HttpStatus.FORBIDDEN);
        }
    }
    async refreshToken(request) {
        let userJWT = request.user;
        let { user, jwt } = await this.authService.refreshToken(userJWT);
        return {
            statusCode: 200,
            message: ["OK"],
            jwt
        };
    }
    async signIn(data) {
        try {
            let { user, jwt } = await this.authService.signIn(data);
            return {
                statusCode: 200,
                message: ["Welcome " + user.name],
                data: user,
                jwt
            };
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: 403,
                message: error.message
            }, common_1.HttpStatus.FORBIDDEN);
        }
    }
};
exports.AuthController = AuthController;
__decorate([
    (0, swagger_1.ApiBody)({
        type: sign_up_dto_1.SignUpDTO
    }),
    (0, swagger_1.ApiOperation)({ summary: 'REGISTRO NUEVO USUARIO', description: '' }),
    (0, common_1.Post)('signup'),
    (0, auth_guard_1.Public)(),
    (0, common_1.HttpCode)(200),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [sign_up_dto_1.SignUpDTO]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "signUp", null);
__decorate([
    (0, swagger_1.ApiOperation)({ summary: 'Refresh Token', description: '' }),
    (0, common_1.Get)('refresh-token'),
    (0, common_1.HttpCode)(200),
    __param(0, (0, common_1.Req)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "refreshToken", null);
__decorate([
    (0, swagger_1.ApiBody)({
        type: auth_dto_1.AuthSigInDTO
    }),
    (0, swagger_1.ApiResponse)({ type: auth_dto_1.AuthSigInResponseDTO }),
    (0, swagger_1.ApiOperation)({ summary: 'INICIO DE SESION', description: '' }),
    (0, auth_guard_1.Public)(),
    (0, common_1.Post)('signin'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.AuthSigInDTO]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "signIn", null);
exports.AuthController = AuthController = __decorate([
    (0, common_1.Controller)('auth'),
    (0, swagger_1.ApiBearerAuth)("authorization"),
    (0, swagger_1.ApiTags)("Auth"),
    __metadata("design:paramtypes", [auth_service_1.AuthService, jwt_1.JwtService])
], AuthController);
//# sourceMappingURL=auth.controller.js.map