"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Migration1747600710513 = void 0;
class Migration1747600710513 {
    constructor() {
        this.name = 'Migration1747600710513';
    }
    async up(queryRunner) {
        await queryRunner.query(`CREATE TABLE "test"."eventos" ("id" SERIAL NOT NULL, "titulo" character varying(200) NOT NULL, "detalle" text NOT NULL, "imagen" character varying(200) NOT NULL, "web" character varying(200) NOT NULL, "telefono" character varying(50) NOT NULL, "latitud" double precision NOT NULL DEFAULT '0', "longitud" double precision NOT NULL, "fecha_evento" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT '"2025-05-18T20:38:34.516Z"', "fecha_creacion" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT '"2025-05-18T20:38:34.516Z"', "state_id" integer, CONSTRAINT "PK_40d4a3c6a4bfd24280cb97a509e" PRIMARY KEY ("id"))`);
        await queryRunner.query(`CREATE TABLE "test"."micros" ("id" SERIAL NOT NULL, "linea" character varying(30) NOT NULL, "inicio" character varying(150) NOT NULL, "fin" character varying(150) NOT NULL, "ruta" text NOT NULL, "imagen" text NOT NULL, "state_id" integer, CONSTRAINT "PK_58ad13e99a19b7117ca17ee9847" PRIMARY KEY ("id"))`);
        await queryRunner.query(`CREATE TABLE "test"."departamento" ("id" SERIAL NOT NULL, "nombre" character varying(200) NOT NULL, "latitud" double precision NOT NULL DEFAULT '0', "longitud" double precision NOT NULL, "fondo" character varying(200) NOT NULL, CONSTRAINT "PK_7fd6f336280fd0c7a9318464723" PRIMARY KEY ("id"))`);
        await queryRunner.query(`CREATE TABLE "test"."tipo_negocio" ("id" SERIAL NOT NULL, "nombre" character varying(200) NOT NULL, CONSTRAINT "PK_73ae6418a463f2dfd2777a82ff5" PRIMARY KEY ("id"))`);
        await queryRunner.query(`CREATE TABLE "test"."negocio_tipo_negocio" ("id" SERIAL NOT NULL, "business_id" integer, "business_type_id" integer, CONSTRAINT "PK_609f7f6cc4628d14f68463413af" PRIMARY KEY ("id"))`);
        await queryRunner.query(`CREATE TABLE "test"."negocio" ("id" SERIAL NOT NULL, "nombre" character varying(80) NOT NULL, "direccion" character varying(80) NOT NULL, "latitud" double precision NOT NULL DEFAULT '0', "longitud" double precision NOT NULL, "vistas" numeric NOT NULL DEFAULT '0', "mejor" numeric NOT NULL DEFAULT '0', "recomendado" numeric NOT NULL DEFAULT '0', "calificacion" numeric NOT NULL DEFAULT '0', "portada" character varying(200) NOT NULL, "logo" character varying(200) NOT NULL, "web" character varying(200) NOT NULL, "telefono" character varying(200) NOT NULL, "descripcion" text NOT NULL, "fecha_actualizacion" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT '"2025-05-18T20:38:34.532Z"', "fecha_creacion" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT '"2025-05-18T20:38:34.532Z"', "state_id" integer, CONSTRAINT "PK_e70f1c8b468e32882bff529cb67" PRIMARY KEY ("id"))`);
        await queryRunner.query(`CREATE TABLE "test"."publicacion" ("id" SERIAL NOT NULL, "detalle" character varying(200) NOT NULL, "title" character varying(80) NOT NULL, "imagen" character varying(200) NOT NULL, "estado" numeric NOT NULL DEFAULT '0', "tipo" numeric NOT NULL, "fecha_actualizacion" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT '"2025-05-18T20:38:34.532Z"', "fecha_creacion" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT '"2025-05-18T20:38:34.532Z"', "business_id" integer, CONSTRAINT "PK_c14e747a7cc735a880bfbf58a70" PRIMARY KEY ("id"))`);
        await queryRunner.query(`CREATE TABLE "test"."comentario" ("id" SERIAL NOT NULL, "detalle" text NOT NULL, "fecha_creacion" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT '"2025-05-18T20:38:34.532Z"', "publication_id" integer, "user_id" integer, CONSTRAINT "PK_c9014211e5fbf491b9e3543bb19" PRIMARY KEY ("id"))`);
        await queryRunner.query(`CREATE TABLE "test"."logger" ("id" SERIAL NOT NULL, "address" character varying(30) NOT NULL, "path" character varying(150) NOT NULL, "action" character varying(150) NOT NULL, "aplication" character varying(150) NOT NULL, "body" text NOT NULL, "duration" numeric NOT NULL DEFAULT '0', "fecha_creacion" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT '"2025-05-18T20:38:34.542Z"', "user_id" integer, CONSTRAINT "PK_46cad7e44f77ea2fa7da01e7828" PRIMARY KEY ("id"))`);
        await queryRunner.query(`CREATE TABLE "test"."usuario" ("id" SERIAL NOT NULL, "nombres" character varying(100) NOT NULL, "apellidos" character varying(100) NOT NULL, "email" character varying(80) NOT NULL, "email_verificado" integer NOT NULL DEFAULT '0', "password" character varying(100) NOT NULL, "estatus" numeric NOT NULL, "tipo_usuario" character varying NOT NULL, "profile" character varying NOT NULL, "fecha_actualizacion" TIMESTAMP WITH TIME ZONE NOT NULL, "fecha_creacion" TIMESTAMP WITH TIME ZONE NOT NULL, CONSTRAINT "PK_a56c58e5cabaa04fb2c98d2d7e2" PRIMARY KEY ("id"))`);
        await queryRunner.query(`ALTER TABLE "test"."eventos" ADD CONSTRAINT "FK_83a816db0c92cd4565f4146870c" FOREIGN KEY ("state_id") REFERENCES "test"."departamento"("id") ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE "test"."micros" ADD CONSTRAINT "FK_0ea4dbb162f68f203de5bcb04a3" FOREIGN KEY ("state_id") REFERENCES "test"."departamento"("id") ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE "test"."negocio_tipo_negocio" ADD CONSTRAINT "FK_6688117c213b73aab930dec23cd" FOREIGN KEY ("business_id") REFERENCES "test"."negocio"("id") ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE "test"."negocio_tipo_negocio" ADD CONSTRAINT "FK_3d1c95118899dbaf37e71bbb00a" FOREIGN KEY ("business_type_id") REFERENCES "test"."tipo_negocio"("id") ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE "test"."negocio" ADD CONSTRAINT "FK_ec42afc589f79cc1973670e1ab8" FOREIGN KEY ("state_id") REFERENCES "test"."departamento"("id") ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE "test"."publicacion" ADD CONSTRAINT "FK_9958655a4094572e52e3c6d2b4b" FOREIGN KEY ("business_id") REFERENCES "test"."negocio"("id") ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE "test"."comentario" ADD CONSTRAINT "FK_45ab79c368adc0e54b5f0e6d050" FOREIGN KEY ("publication_id") REFERENCES "test"."publicacion"("id") ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE "test"."comentario" ADD CONSTRAINT "FK_b79b3eb8748573a4cca6d1939f7" FOREIGN KEY ("user_id") REFERENCES "test"."usuario"("id") ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE "test"."logger" ADD CONSTRAINT "FK_063112e212e4d841f4c7cedc269" FOREIGN KEY ("user_id") REFERENCES "test"."usuario"("id") ON DELETE NO ACTION ON UPDATE NO ACTION`);
    }
    async down(queryRunner) {
        await queryRunner.query(`ALTER TABLE "test"."logger" DROP CONSTRAINT "FK_063112e212e4d841f4c7cedc269"`);
        await queryRunner.query(`ALTER TABLE "test"."comentario" DROP CONSTRAINT "FK_b79b3eb8748573a4cca6d1939f7"`);
        await queryRunner.query(`ALTER TABLE "test"."comentario" DROP CONSTRAINT "FK_45ab79c368adc0e54b5f0e6d050"`);
        await queryRunner.query(`ALTER TABLE "test"."publicacion" DROP CONSTRAINT "FK_9958655a4094572e52e3c6d2b4b"`);
        await queryRunner.query(`ALTER TABLE "test"."negocio" DROP CONSTRAINT "FK_ec42afc589f79cc1973670e1ab8"`);
        await queryRunner.query(`ALTER TABLE "test"."negocio_tipo_negocio" DROP CONSTRAINT "FK_3d1c95118899dbaf37e71bbb00a"`);
        await queryRunner.query(`ALTER TABLE "test"."negocio_tipo_negocio" DROP CONSTRAINT "FK_6688117c213b73aab930dec23cd"`);
        await queryRunner.query(`ALTER TABLE "test"."micros" DROP CONSTRAINT "FK_0ea4dbb162f68f203de5bcb04a3"`);
        await queryRunner.query(`ALTER TABLE "test"."eventos" DROP CONSTRAINT "FK_83a816db0c92cd4565f4146870c"`);
        await queryRunner.query(`DROP TABLE "test"."usuario"`);
        await queryRunner.query(`DROP TABLE "test"."logger"`);
        await queryRunner.query(`DROP TABLE "test"."comentario"`);
        await queryRunner.query(`DROP TABLE "test"."publicacion"`);
        await queryRunner.query(`DROP TABLE "test"."negocio"`);
        await queryRunner.query(`DROP TABLE "test"."negocio_tipo_negocio"`);
        await queryRunner.query(`DROP TABLE "test"."tipo_negocio"`);
        await queryRunner.query(`DROP TABLE "test"."departamento"`);
        await queryRunner.query(`DROP TABLE "test"."micros"`);
        await queryRunner.query(`DROP TABLE "test"."eventos"`);
    }
}
exports.Migration1747600710513 = Migration1747600710513;
//# sourceMappingURL=1747600710513-migration.js.map