"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const typeorm_1 = require("typeorm");
const dotenv_1 = require("dotenv");
const typeorm_naming_strategies_1 = require("typeorm-naming-strategies");
(0, dotenv_1.config)();
exports.default = new typeorm_1.DataSource({
    type: 'postgres',
    host: process.env.DB_HOST,
    port: +process.env.DB_PORT,
    username: process.env.DB_USER,
    password: process.env.DB_PASSWORD,
    database: process.env.DB_NAME,
    schema: process.env.DB_SCHEMA,
    entities: ['src/entity/**/*.entity.{ts,js}'],
    namingStrategy: new typeorm_naming_strategies_1.SnakeNamingStrategy(),
    migrations: ['src/database/migrations/**/*.{ts,js}'],
    ssl: { rejectUnauthorized: false }
});
//# sourceMappingURL=migration.config.js.map