"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppModule = void 0;
const common_1 = require("@nestjs/common");
const user_module_1 = require("./modules/user/user.module");
const business_module_1 = require("./modules/business/business.module");
const review_module_1 = require("./modules/review/review.module");
const publication_module_1 = require("./modules/publication/publication.module");
const state_module_1 = require("./modules/state/state.module");
const auth_module_1 = require("./modules/auth/auth.module");
const config_1 = require("@nestjs/config");
const typeorm_1 = require("@nestjs/typeorm");
const jwt_1 = require("@nestjs/jwt");
const config_database_1 = require("./util/config-database");
const core_1 = require("@nestjs/core");
const auth_guard_1 = require("./middleware/auth.guard");
const admin_role_1 = require("./middleware/admin.role");
const micro_module_1 = require("./modules/micro/micro.module");
const logging_interceptor_1 = require("./util/interceptor/logging.interceptor");
const log_entity_1 = require("./entity/log.entity");
const app_service_1 = require("./app.service");
let AppModule = class AppModule {
};
exports.AppModule = AppModule;
exports.AppModule = AppModule = __decorate([
    (0, common_1.Module)({
        imports: [
            config_1.ConfigModule.forRoot({
                isGlobal: true
            }),
            typeorm_1.TypeOrmModule.forRoot(config_database_1.DB_CONFIG),
            typeorm_1.TypeOrmModule.forFeature([log_entity_1.LoggingEntity]),
            jwt_1.JwtModule.register(config_database_1.JWT_CONFIG),
            user_module_1.UserModule, business_module_1.BusinessModule, review_module_1.ReviewModule, publication_module_1.PublicationModule, state_module_1.StateModule, auth_module_1.AuthModule, micro_module_1.MicroModule
        ],
        controllers: [],
        providers: [
            {
                provide: core_1.APP_GUARD,
                useClass: auth_guard_1.AuthGuard,
            },
            {
                provide: core_1.APP_GUARD,
                useClass: admin_role_1.RoleAdminGuard,
            },
            {
                provide: core_1.APP_INTERCEPTOR,
                useClass: logging_interceptor_1.LoggingInterceptor
            },
            app_service_1.AppService
        ],
    })
], AppModule);
//# sourceMappingURL=app.module.js.map